﻿class com.gskinner.util.PList {
        
// Public Methods
        public static function deserialize(p_xml:XML):Object {
                // Assume the first Node is the <plist> node.  Parse starting below that...
                return parseNode(p_xml.firstChild.firstChild);
        }
        
        public static function serialize(p_obj:Object):XML {
                return buildXML(p_obj);
        }
        
        
// Private Methods

/* DESERIALIZATION */
        private static function parseNode(p_node:XMLNode) {
                var type:String = p_node.nodeName;
                var content = (p_node.firstChild.nodeType == 3) ? p_node.firstChild.nodeValue : null;
                switch(type) {
                        case "plist": return parseObject(p_node);
                        case "dict": return parseObject(p_node); 
                        case "array": return parseArray(p_node);
                        case "integer": return parseInt(content);
                        case "real": return Math.abs(parseInt(content));
                        case "number": return Number(content);
                        case "string": 
                        case "data": return content.split("\n").join(""); // Remove extra linefeed
                        case "true": return true;
                        case "false": return false;
                }
        }
        
        private static function parseObject(p_node):Object {
                var obj:Object = {};
                var l:Number = p_node.childNodes.length;
                for (var i:Number=0; i<l; i++) {
                        var node:XMLNode = p_node.childNodes[i];
                        var name:String = node.nodeName;
                        var label:String = node.firstChild.nodeValue;
                        i++; // Key/Value Pairs need next item...
                        
                        if (p_node.childNodes[i].nodeName == "key") {
                                obj[label] = null;
                                i--;
                        } else {
                                obj[label] = parseNode(p_node.childNodes[i]); // Parse Name/Key Pair
                        }
                }
                return obj;
        }
        
        private static function parseArray(p_node:XMLNode):Array {
                var arr:Array = [];
                var l:Number = p_node.childNodes.length;
                for (var i:Number=0; i<l; i++) {
                        arr.push(parseNode(p_node.childNodes[i]));
                }
                return arr;
        }
        
/*
        SERIALIZATION
*/
        private static function buildXML(p_obj):XML {
                var xmlTemplate:String = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\"><plist version=\"1.0\"><dict></dict></plist>";
                var x:XML = new XML(xmlTemplate);               
                for (var i:String in p_obj) {
                        buildNode(x, x.firstChild.firstChild, p_obj[i], i);
                }
                return x;
        }
        
        private static function buildNode(p_xml, p_node, p_obj, p_name):Void {
                // Create Key
                if (p_name != undefined) { createNode(p_xml, p_node, "key", p_name); }
                
                // Create Values
                if (p_obj === true || p_obj === false) { // Boolean
                        createNode(p_xml, p_node, (p_obj == true) ? "true" : "false");
                } else if (!isNaN(p_obj)) { // Number
                        createNode(p_xml, p_node, "number", p_obj);
                } else if (p_obj instanceof String || typeof(p_obj) == "string") { // String
                        createNode(p_xml, p_node, "string", p_obj);
                } else if (p_obj instanceof Array) {
                        var node:XMLNode = createNode(p_xml, p_node, "array");
                        var l:Number = p_obj.length;
                        for (var i:Number=0; i<l; i++) { buildNode(p_xml, node, p_obj[i]); }
                } else if (p_obj instanceof Object) {
                        var node:XMLNode = createNode(p_xml, p_node, "dict");
						trace('p_xml' + p_xml)
                        for (var i:String in p_obj) { 
							buildNode(p_xml,node, p_obj[i], i); 
						}
                }
        }
        
        private static function createNode(p_xml:XML, p_node:XMLNode, p_key:String, p_value:String):XMLNode {
                var node:XMLNode = p_xml.createElement(p_key);
                p_node.appendChild(node);
                if (p_value != undefined) {
                        var nodeValue:XMLNode = p_xml.createTextNode(p_value);
                        p_node.lastChild.appendChild(nodeValue);
                        return;
                } else {
                        return node;
                }
        }
        
}